//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdlib>
#include <vector>
#include <list>
#include <map>
#include <string>
#pragma hdrstop

#include "Unit1.h"
#include "WrkObjs.h"
//
using namespace std;
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TForm1::QuitButtonClick(TObject *Sender)
{
    exit(0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VectorButtonClick(TObject *Sender)
{
vector<int> myInts;

    ListBox1->Clear();
    ListBox1->Items->Add("Vector Example");
    ListBox1->Items->Add("==============");
    // Add numbers 1-9 to myInts
    for( int y = 1; y < 10; y++ )
      myInts.push_back(y);

    // Add them to ListBox1 using array subscripting
    ListBox1->Items->Add("After adding 1 through 9:");
    for( int y = 0; y < 9; y++ )
      ListBox1->Items->Add(String(myInts[y]));

    // Oops, we wanted 0-10, not 1-9.
    // So, let's add 10 to end of vector
    myInts.push_back(10);

    // Still need leading 0!  Call insert
    // and send the result of myInts.begin()
    // as an argument.  The begin function
    // returns an iterator pointing at the
    // beginning of the vector.
    myInts.insert(myInts.begin(), 0);

    // Show the contents of the vector with
    // the 0 and 10 that were missing before.
    ListBox1->Items->Add("After adding 0 and 10:");
    for( int y = 0; y < 11; y++ )
      ListBox1->Items->Add(String(myInts[y]));

    // For practice, remove the 10 from the end
    // and place a 25 on the there.
    myInts.pop_back();
    myInts.push_back(25);

    // Dump the vector again.  Now, it's 0-9 followed by 25
    ListBox1->Items->Add("After deleting 10 and adding 25:");
    for( int y = 0; y < 11; y++ )
      ListBox1->Items->Add(String(myInts[y]));

    // Remove all entries from the vector...this
    // is not strictly necessary.  The vector will
    // be going out of scope shortly anyway.
    myInts.clear();
    ListBox1->Items->Add("Vector example complete!");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ListButtonClick(TObject *Sender)
{
list<Wisdom*> myWisdom;
list<Wisdom*>::iterator wisIt;
char sentence[50];
char* myWords[] = {
"a ", "nice ", "day ", "Have "};

    ListBox1->Clear();
    ListBox1->Items->Add("List Example");
    ListBox1->Items->Add("============");

    // Add all words to the list from the
    // myWords array.
    for( int x = 0; x < 4; x++ ) {
      char* wordMemory = new char[strlen(myWords[x]+1)];
      strcpy(wordMemory, myWords[x]);
      myWisdom.push_back(new Wisdom(wordMemory));
    }

    // Form a sentence by concatenating all
    // of the all of the character strings
    // stored in the list.
    ListBox1->Items->Add("My Words of wisdom:");
    *sentence = NULL;
    for( wisIt = myWisdom.begin();
         wisIt != myWisdom.end(); wisIt++ )
      strcat(sentence, (*wisIt)->say());
    ListBox1->Items->Add(sentence);

    // Well, that wasn't quite right!  "Have"
    // should have been at the beginning of the
    // sentence!  Get an iterator pointing to the
    // end of the list, then cast it to the last
    // Widsom object pointer stored there.
    wisIt = myWisdom.end();
    Wisdom* tmpWis = (*(--wisIt));

    // Remove the item from the list matching the
    // Wisdom pointer (effectively, the word "Have").
    myWisdom.remove(tmpWis);

    // Now, place "Have" in the front
    myWisdom.push_front(tmpWis);
    ListBox1->Items->Add("My Words of wisdom (corrected):");
    *sentence = NULL;

    // Rebuild the sentence again.  This time, as
    // each word is added to the sentence, we're
    // deleting the Wisdom object pointed to by
    // the list.  After the for loop, there are no
    // longer any valid pointers in myWisdom!
    for( list<Wisdom*>::iterator li = myWisdom.begin();
         li != myWisdom.end(); li++ ) {
      strcat(sentence, (*li)->say());
      delete (*li);
    }
    ListBox1->Items->Add(sentence);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MultimapButtonClick(TObject *Sender)
{
map<string, Person> anyBody;
map<string, Person>::iterator persIter;

  ListBox1->Clear();
  ListBox1->Items->Add("Multimap Example");
  ListBox1->Items->Add("================");

  // Add some people to the map
  anyBody["honest"] =
    Person("Abe Lincoln", 98);
  anyBody["cherry tree"] =
    Person("George Washington", 100);
  anyBody["watergate"] =
    Person("Richard Nixon", 74);
  anyBody["pardon"] =
    Person("Gerald Ford", 76);
  anyBody["peanuts"] =
    Person("Jimmy Carter", 80);
  anyBody["scandal"] =
    Person("Bill Clinton", 92);

  // Find a couple of people and print them to
  // the ListBox.  Being able to search by
  // placing the key in the brackets is convenient!
  Person who = anyBody["honest"];
  ListBox1->Items->Add((who.getName()).c_str());
  who = anyBody["watergate"];
  ListBox1->Items->Add((who.getName()).c_str());

  // Delete Gerald Ford by calling the erase
  // function with his key.
  anyBody.erase("pardon");

  // Getting an iterator back from the find
  // function is a better way to look for
  // entries in the list.
  persIter = anyBody.find("pardon");
  if (persIter != anyBody.end())
      ListBox1->Items->Add((who.getName()).c_str());
    else
      ListBox1->Items->Add("No such president!");
}
//---------------------------------------------------------------------------

